<?php
/**
 * The template for displaying Category pages
 *
 * @link http://codex.wordpress.org/Template_Hierarchy
 *
 * @package WordPress
 * @subpackage Twenty_Thirteen
 * @since Twenty Thirteen 1.0
 */

get_header(); ?>
	<div id="primary" class="content-area">
		<div id="content" class="site-content" role="main">
            <?php 
             $getNumberOfPosts = get_option('posts_per_page') * ((get_query_var('paged')) ? get_query_var('paged') : 1);
            ?>
<?php if(false){ ?>
		<?php if ( have_posts() ) : ?>
			<header class="archive-header center">
				<h2 class="archive-title"><?php printf( __( 'Category Archives: %s', 'twentythirteen' ), single_cat_title( '', false ) ); ?></h2>

				<?php if ( category_description() ) : // Show an optional category description ?>
				<div class="archive-meta"><?php echo category_description(); ?></div>
				<?php endif; ?>
			</header><!-- .archive-header -->

			<?php /* The loop */ ?>
			<?php while ( have_posts() ) : the_post(); ?>
				<?php get_template_part( 'content', get_post_format() ); ?>
			<?php endwhile; ?>

			<?php twentythirteen_paging_nav(); ?>

		<?php else : ?>
			<?php get_template_part( 'content', 'none' ); ?>
		<?php endif; ?>
<?php } ?>
            
        <article>
            <ol class="_noListStyle roman" id="rulesDescriptions">
                <?php
                    $postsCounter = 1;
                    while(have_posts()) : the_post(); ?>
                    <li>
                        <a class="linkTarget" name="rule_no_<?php echo $post->ID?>">&nbsp;</a>
                        <div class="rule-desc">
                            <h3><?php echo romanNumerals(($getCategoryPostsNumber - $getNumberOfPosts) + $postsCounter); ?>. <?php the_title();?></h3>
                            <div class="rule-content">
                                <?php the_content_feed(); ?>
                            </div>
                        </div>
                    </li>
                <?php 
                    $postsCounter++;
                endwhile;
                ?> 
            </ol>
            <div class="clear"></div>
        </article>
        <?php twentythirteen_paging_nav(); ?>
            
		</div><!-- #content -->
	</div><!-- #primary -->

<?php get_sidebar(); ?>
<?php get_footer(); ?>