<?php
/**
 * The Header template for our theme
 *
 * Displays all of the <head> section and everything up till <div id="main">
 *
 * @package WordPress
 * @subpackage Twenty_Thirteen
 * @since Twenty Thirteen 1.0
 */

if($_POST['length'] && $_POST['length'] > 8){
        $length = $_POST['length'];
}else{ $length = LENGTH; }



?><!DOCTYPE html>
<!--[if IE 7]>
<html class="ie ie7" <?php language_attributes(); ?>>
<![endif]-->
<!--[if IE 8]>
<html class="ie ie8" <?php language_attributes(); ?>>
<![endif]-->
<!--[if !(IE 7) | !(IE 8)  ]><!-->
<html <?php language_attributes(); ?>>
<!--<![endif]-->
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width">
	<title><?php wp_title( '|', true, 'right' ); ?></title>
	<link rel="profile" href="http://gmpg.org/xfn/11">
	<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">
    <link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/css/bootstrap.css">
    <?php wp_head(); ?>
    <link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/css/fonts.css">
    
    <!--[if lt IE 9]>
        <script src="<?php echo get_template_directory_uri(); ?>/js/html5.js"></script>
	<![endif]-->
    <script src="http://ajax.googleapis.com/ajax/libs/jquery/1.8.2/jquery.min.js"></script>
    <script type="text/javascript" src="<?php echo get_template_directory_uri(); ?>/js/box-shadow-animate.js"></script>
    <script type="text/javascript" src="<?php echo get_template_directory_uri(); ?>/js/form.js"></script>
    <script type="text/javascript" src="<?php echo get_template_directory_uri(); ?>/js/script.js"></script>
    <script type="text/javascript">
        var equalShowText = '<?php _e( 'Pokaż więcej', 'twentythirteen' ); ?>';
        var equalHideText = '<?php _e( 'Zwiń', 'twentythirteen' ); ?>';
    </script>
    <script>
        (function(i,s,o,g,r,a,m){i['GoogleAnalyticsObject']=r;i[r]=i[r]||function(){
        (i[r].q=i[r].q||[]).push(arguments)},i[r].l=1*new Date();a=s.createElement(o),
        m=s.getElementsByTagName(o)[0];a.async=1;a.src=g;m.parentNode.insertBefore(a,m)
        })(window,document,'script','//www.google-analytics.com/analytics.js','ga');

        ga('create', 'UA-45917678-1', 'webvisor.pl');
        ga('send', 'pageview');
    </script>
</head>
<body <?php body_class(); ?>>
    <header>
        <p id="headerText"><?php bloginfo( 'description' ); ?></p>
        <h1><a title="<?php bloginfo( 'name' ); ?> - <?php bloginfo( 'description' ); ?>" href="/"><?php bloginfo( 'name' ); ?></a></h1>
        <section id="passForm">
            <div id="toRight">
                <?php 
                    dynamic_sidebar('generator-form');
                ?>  
            </div>
        </section>
        <section id="rules">
            <div id="toLeft">
                <h2><?php _e( 'Zanim wpiszesz hasło (co warto wiedzieć):', 'twentythirteen' ); ?></h2>
                <ol class="roman express-anchorn-target" start="<?php echo ($getCategoryPostsNumber - $getNumberOfPosts) + 1; ?>">
                    <?php
                    $catPosts = takeLastPostFrom(10,2);
                    while($catPosts->have_posts()) : $catPosts->the_post(); 
                        if(is_front_page()){
                    ?>
                        <li><h3><a href="#rule_no_<?php //the_permalink(); ?><?php echo $post->ID; ?>" rel="bookmark"><?php echo (get_field('customer_seo_freendly_title')) ? strip_tags(get_field('customer_seo_freendly_title'),'<strong><b><em><i><u>') :  get_the_title(); ; ?></a></h3></li>
                    <?php 
                        }else{ ?>
                        <li><h3><a href="<?php the_permalink(); ?>" rel="bookmark"><?php echo (get_field('customer_seo_freendly_title')) ? strip_tags(get_field('customer_seo_freendly_title'),'<strong><b><em><i><u>') :  get_the_title(); ; ?></a></h3></li>
                    <?php }
                    endwhile; ?> 
                </ol>
                <a id="topSavePassCategory" href="<?php echo get_category_link(2);?>" title="<?php _e( 'Zobacz wszystkie wpisy z kategorii: ', 'twentythirteen' ); echo get_category(2)->name; ?>"><?php _e( 'Zobacz wszystkie wpisy z kategorii: ', 'twentythirteen' );?><?php echo get_category(2)->name; ?></a>
            </div>
        </section>
        <div class="clear"></div>
    </header>
	<div id="page" class="hfeed site">
		<div id="main" class="site-main">
            
            <?php if ( function_exists('yoast_breadcrumb') && !is_home() ) {
            yoast_breadcrumb('<p id="breadcrumbs">','</p>');
            } ?>