<?php
/**
 * The main template file
 *
 * This is the most generic template file in a WordPress theme and one of the
 * two required files for a theme (the other being style.css).
 * It is used to display a page when nothing more specific matches a query.
 * For example, it puts together the home page when no home.php file exists.
 *
 * @link http://codex.wordpress.org/Template_Hierarchy
 *
 * @package WordPress
 * @subpackage Twenty_Thirteen
 * @since Twenty Thirteen 1.0
 */

get_header(); ?>
        <article>
            <ol class="_noListStyle roman" id="rulesDescriptions">
                
                <?php
                    query_posts('showposts='.$getNumberOfPosts.'&cat='.$categoryID.'&order=asc');
                    $postsCounter = 1;
                    while(have_posts()) : the_post();
                    ?>
                    <li>
                        <a class="linkTarget" name="rule_no_<?php echo $post->ID?>">&nbsp;</a>
                        <div class="rule-desc">
                            <h3><?php echo romanNumerals(($getCategoryPostsNumber - $getNumberOfPosts) + $postsCounter); ?>. <?php the_title();?></h3>
                            <div class="rule-content">
                                <?php the_content_feed(); ?>
                            </div>
                        </div>
                    </li>
                <?php 
                    $postsCounter++;
                endwhile;
                ?> 
            </ol>
            <div class="clear"></div>
        </article>
<?php get_sidebar(); ?>
<?php get_footer(); ?>