(function($) {
    $.fn.getAttributes = function(data) {// pre - przedrostek dla szukanych atrybutĂłw; type - jeĹźeli false to zwrĂłci string zamiast tablicy
        var checkPre = false
        if( typeof(data.pre) !== 'undefined' ){
            checkPre = true;
        }
        var attributes = {}; 
        var array = true;
        if(  ( typeof(data.array) !== 'undefined' ) && ( data.array == false )  ){
            array = false;
            var attributes = ''; 
        }
        if(!this.length) return null;
        $.each(this[0].attributes, function(index, attr) {
            if( checkPre && (attr.name.indexOf(data.pre) >= 0) ){
                if(array){
                    attributes[attr.name] = attr.value;
                }else{
                    attributes += attr.name+'="'+attr.value+'" ';
                }
            }else if( !checkPre ){
                if(array){
                    attributes[attr.name] = attr.value;
                }else{
                    attributes += attr.name+'="'+attr.value+'" ';
                }
            }
            
        }); 
        return attributes;
    }
})(jQuery);

$.fn.extend({
  toggleAttr : function( attrib ) { // moĹźna przekazaÄ tablicÄ parametrĂłw do podmiany - tablica moĹźe zawieraÄ rĂłnieĹź tablicÄ: klucz: wartosc
    if(typeof(attrib) !== 'object'){
        attrib = [attrib];
    }
    var attr = '';
    for( var i=0, aCount = attrib.length ; i<aCount; i++ ){
        attr = attrib[i];
        if(typeof(attr) === 'object'){
            var key = attr[0];
            var value = attr[1];
        }else{
            var key = attr;
            var value = attr;
        }
        if ( this.attr( key ) ) {
          this.removeAttr( key );
        } else {
          this.attr( key, value );
        }
    }
    return true;
  }
});

function IsNumeric(input){
    var RE = /^-{0,1}\d*\.{0,1}\d+$/;
    return (RE.test(input));
}

function isSet(_val){
    if( typeof(_val) !== 'undefined') return true;
    return false;
}

function Form(){
    this.selectPrompt = 'Wybierz';
    this.formErrors = [];
    this.Select();
    this.Radio();
    this.Checkbox();
    this.File();
}


Form.prototype.Select = function(){ 
    var self = this;
   $('.select').each(function(){
        var name = $(this).attr('name')
        $(this).hide();
	//$(this).val('');

        var selectData = $(this).getAttributes({pre: 'data', array: false});
        $(this).find('option').each(function(){
            if(isSet($(this).attr('data-replace')) && $(this).attr('data-replace') != ''){
                $(this).text($(this).attr('data-replace'));
            }
        })
        var selected = $(this).children(':selected');
        var prompt = self.selectPrompt;
        if( isSet($(this).attr('data-placeholder')) ){
            prompt = $(this).attr('data-placeholder');
        } else if( isSet(selected) ){
            prompt = selected.text();
        }
        var fakeSelect = '<div class="fake-select" ' + selectData + ' fake-id="'+ $(this).attr('id') +'" ><span class="fake-value" data-placeholder="'+prompt+'">'+ prompt +'</span></div>';
        $(this).after(fakeSelect);
        $(this).change();
    })
    this.selectClickHandle();
}



Form.prototype.selectClickHandle = function(){
   $('.fake-select').click(function(){
        var id = $(this).attr('fake-id');
        if($(this).children('.fake-select-list').length > 0){
            $('#fake-'+id).remove();
            return false;
        }
        var attrs = '';
        var list = '';
        $('#'+id + ' option').each( function(){
            attrs = $(this).getAttributes({pre: 'data', array: false});
            list += '<li ' + attrs + ' data-value="' + $(this).attr('value') + '"><span>' + $(this).html() + '</span></li>'+"\n";
        });
        var fake_select = '<ul class="fake-select-list" id="fake-' + id + '">'+"\n" + list + '</li></ul>';
        $(this).append(fake_select);
        $(this).children('.fake-select-list').hide().slideDown('400');
        var parent = this;
        $('.fake-select-list li').bind('click',function(){
            $(this).addClass('fake-select-active');
            var fakeValue = $(this).children('span').html()+'';
            $('*[fake-id='+id+'] .fake-value').html(fakeValue);
            var value = $(this).attr('data-value');
            
            $('#'+id + " option").removeAttr('selected');
            $('#'+id + " option").filter(function() {
                //may want to use $.trim in here
                return $(this).attr('value') == value; 
            }).attr('selected', true);
                
            $('#'+id).val(value).change();
            $('#fake-'+id).slideUp('400',function(){$(this).remove()});
            
            return false;
        });
   });
}

Form.prototype.Radio = function(){
    var self = this;
    $('.radio').each(function(){
        var name = $(this).find('input[type=radio]:first').attr('name');
        var addClass = '';
        if(typeof($(this).attr('data-class')) !== 'undefined') {
            addClass = $(this).attr('data-class');
        }

        $(this).hide();
        var checked = $(this).children(':checked');

        var fakeRadio = '<ul data-name="' + name + '" id="fake-'+ name + '" class="fakeRadio ' + addClass + '"></ul>';
        $(this).after(fakeRadio);
        fakeRadio = $('#fake-'+name);
        var attrs = '';
        var radioOptions = '';
        var checked = '';
        
        $(this).find('label').each(function(){
            attrs = $(this).find('input[type=radio]').getAttributes({pre: 'data',array: false});
            checked = ''
            if( typeof($(this).find('input[type=radio]').attr('checked')) !== 'undefined' ){ checked = ' class="active" '; }
            radioOptions += '<li '+ attrs +' '+checked+' data-value="'+ $(this).find('input[type=radio]').val() +'">' + $.trim($(this).text()) + '</li>';
        })

        fakeRadio.append(radioOptions);
    })
    this.radioClickHandle();
}

Form.prototype.radioClickHandle = function(){
    var self = this;
    $('.fakeRadio li').bind('click',function(event){
        //event.stopImmediatePropagation();
        $(this).parent().find('li').removeClass('active');
        $(this).addClass('active');
        var value = $(this).attr('data-value');
        var name = $(this).parent().attr('data-name');
        $("input[name="+name+"]").filter(function() {
                //may want to use $.trim in here
                $(this).removeAttr('checked');
                return $(this).attr('value') == value; 
            }).change().attr('checked', true);
        return true;
    })
}

Form.prototype.Checkbox = function(){
    var self = this;
    $('.checkbox').each(function(){
        var name = $(this).find('input[type=checkbox]:first').attr('name');
        var nameArray = '';
        //if(  name.indexOf('[]') !== -1 ) {
        if(  name.indexOf('[') !== -1 ) {
            nameArray = '[]';
            name = name.replace('[]','');
        }
        
        $(this).addClass('hideCheckboxes');
        var selected = $(this).children(':checked');

        var fakeCheckbox = '<ul data-name="' + name + '" id="fake-'+ name + '" data-name-array="'+ nameArray +'" class="fakeCheckbox"></ul>';
        $(this).before(fakeCheckbox);
        fakeCheckbox = $('#fake-'+name);
        var attrs = '';
        var checkboxOptions = '';
        
        $(this).find('label').each(function(){
            var radio = $(this).find('input[type=checkbox]');
            attrs = radio.getAttributes({pre: 'data',array: false});
            var thisID = radio.attr('id');
            var title = radio.attr('title');
            if(typeof(title) === 'undefined') title = $(this).attr('title');
            if(title){ title = 'title="'+ title +'"' };
            var active = '';
            if(radio.attr('checked'))
                    active += 'class="active"';
            checkboxOptions += '<li '+ active + attrs + title +' data-value="'+ radio.val() +'" data-this-id="'+thisID+'" >';
                if( ( typeof(radio.attr('data-html-data')) !== 'undefined' ) ){
                    var tempOption = $.trim($(this).html());
                    tempOption = tempOption.replace(/\<input[^\>]*\>/i,"");
                    checkboxOptions += tempOption;
                }else{
                    checkboxOptions += $.trim($(this).text());
                }
                checkboxOptions += '</li>';

        })
        fakeCheckbox.append(checkboxOptions);
    })
    this.checkboxClickHandle();
}

Form.prototype.checkboxClickHandle = function(){
    var self = this;
    $('.fakeCheckbox li').click(function(){
        var value = $(this).attr('data-value');
        var name = $(this).parent().attr('data-name');
        var nameArray = $(this).parent().attr('data-name-array');
        var thisID = $(this).attr('data-this-id');
        /*
        var nameArray = false;
        if( name.indexOf('[]') !== -1 ) {
            nameArray = true;
            name = name.replace('[]','');
        }*/
        $(this).toggleClass('active');
//        vardump(name);

        $("input#"+thisID).filter(function() {
                //may want to use $.trim in here
                return $(this).attr('value') == value; 
        }).change().toggleAttr('checked');
        /*
        if(nameArray.length > 0){
            $("input#"+thisID).filter(function() {
                //may want to use $.trim in here
                return $(this).attr('value') == value; 
                
            }).change().toggleAttr('checked');
        }else{
            $("input[name="+name+nameArray+"]").filter(function() {
                //may want to use $.trim in here
                return $(this).attr('value') == value; 
            }).change().toggleAttr('checked');
        }
        */
    })
       
    return true;
}

Form.prototype.ValidateForm = function(form){
    this.formErrors = [];
    if (typeof (document.createElement("input").checkValidity) == "function") {
            return true;  //chwilowo wyĹÄczam walidacje przeglÄdarki
    }
    var self = this;
    $(form).find('input,textarea').each(function(){
        //vardump($(this));
        $(this).removeClass('error');
        $(this).parents('tr').find('.errorInfo').remove();
        if( $(this).attr('required') ){self.Validate($(this))}
    })
    if(this.formErrors.length > 0) return false;
    return true;
}

Form.prototype.Validate = function(el){
         if( el.attr('type') && el.attr('type') == 'email' ) this.ValidateEmail(el);
    else if( el.attr('type') && el.attr('type') == 'number' ) this.ValidateNumber(el);
    else this.ValidateText(el);
}

Form.prototype.ValidateEmail = function(el){
    var value = $.trim(el.attr('value'));
    if(!value) {this.FormError(el);return false;}
    var placeholder = '';
    
    if( typeof(el.attr('placeholder')) ) placeholder = el.attr('placeholder')
    var re = /^(([^<>()[\]\\.,;:\s@\"]+(\.[^<>()[\]\\.,;:\s@\"]+)*)|(\".+\"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\])|(([a-zA-Z\-0-9]+\.)+[a-zA-Z]{2,}))$/;
    
    if( value != placeholder && re.test(value)) return true;
    this.FormError(el);
    return false;
}

Form.prototype.ValidateText = function(el){
    var value = $.trim(el.attr('value'));
    if(!value) {this.FormError(el);return false;}
    var placeholder = '';
    if( typeof(el.attr('placeholder')) ) placeholder = el.attr('placeholder'); 
    
    if( value != placeholder) return true;
    
   this.FormError(el);return false;
}

Form.prototype.ValidateNumber = function(el){
    var value = $.trim(el.attr('value'));
    if( !IsNumeric(value) ) {this.FormError(el);return false;}
    return true;
}

Form.prototype.FormError = function(el){
    el.addClass('error');
    el.parents('tr').append('<td class="errorInfo">'+ el.attr('data-error') +'</td>');
    this.formErrors.push(el.attr('data-error'));return false;
}

Form.prototype.File = function(){
    $('input[type="file"]').addClass('hideFileInput').wrap('<div class="fileWraper" />').parents('.fileWraper').append('<input type="text" class="fakeFileInput" value="Kliknij, aby dodaÄ." />');
    this.fileChangeHandle();
}

Form.prototype.fileChangeHandle = function(){
    $('input[type="file"]').on('change', function(){
        var files = '';
        for( var i = 0, length = this.files.length; i < length; i++ ){
            files += this.files[0].name + ' ';
        }
        files = 'Wybrano ' + this.files.length + ' plików: ' + files;
        $(this).next('.fakeFileInput').val(files);
//        vardump(files);
    })
}

Form.prototype.setAllCheckboxValuesPositive = function(submit){
    var formEl = $(submit).parents('form');
    if( formEl.find('.fakeCheckbox li.active').length == 0 ) formEl.find('.fakeCheckbox li').addClass('active');
    //vardump(formEl.find('.fakeCheckbox li.active'));
    return false;
}

$(document).ready(function(){
    var form = new Form();
    $('#send').click(function(){ 
        form.setAllCheckboxValuesPositive(this); 
        return false; })
    /*
    $('#nextStep, .nextStep').click(function(){ 
        var result = form.ValidateForm( $(this).parents('form') );
        return result;  // form.ValidateForm('#userDataHolder');
    })*/
    
})

