var length = 8;
var minLength = 6;

var ruleDescriptionHeigh = 122;

function c(v){
    console.log(typeof ($('#'+v ).is(':checked')));
    if ( $('#'+v ).is(':checked') ) return 1;
    return null;
}


function range(start, end, step) {
    var range = [];
    var typeofStart = typeof start;
    var typeofEnd = typeof end;

    if (step === 0) {
        throw TypeError("Step cannot be zero.");
    }

    if (typeofStart == "undefined" || typeofEnd == "undefined") {
        throw TypeError("Must pass start and end arguments.");
    } else if (typeofStart != typeofEnd) {
        throw TypeError("Start and end arguments must be of same type.");
    }

    typeof step == "undefined" && (step = 1);

    if (end < start) {
        step = -step;
    }

    if (typeofStart == "number") {

        while (step > 0 ? end >= start : end <= start) {
            range.push(start);
            start += step;
        }

    } else if (typeofStart == "string") {

        if (start.length != 1 || end.length != 1) {
            throw TypeError("Only strings with one character are supported.");
        }

        start = start.charCodeAt(0);
        end = end.charCodeAt(0);

        while (step > 0 ? end >= start : end <= start) {
            range.push(String.fromCharCode(start));
            start += step;
        }

    } else {
        throw TypeError("Only string and number types are supported");
    }

    return range;

}


var toType = function(obj) {
  return ({}).toString.call(obj).match(/\s([a-zA-Z]+)/)[1].toLowerCase()
}

function vardump(_var){
    console.log( 'Varialbe type: ' + toType(_var) + "\n"+'variable content: ')
    console.log(_var);
}

function makePass(mode, length){
    var config = {};
    config.mode = mode;
    config.length = length;
    var pass = '';
    
    var values = '';
    if( config.mode.numbers ){
        values += range(0,9).join('');
    }
    if( config.mode.normalChars ){
        values += '-|=[];,.!@#$^&()_+{}:<>?';
    }
    if( config.mode.specialChars ){
        values += '\'/~%*`"';
    }
    if( config.mode.lowerLetters ){
        values += range('a','z').join('');
    }
    if( config.mode.upperLetters ){
        values += range('A','Z').join('');
    }
    vLength = values.length;
    //vardump(vLength);
    for( var i=0; i<config.length; i++){
        pass += values.substr( Math.random()*vLength, 1);
    }
    
    $('#pass #generatedPass').attr('value', pass ).select();
}

function getSelectedText() {
    if (window.getSelection) {
        return window.getSelection();
    } else if (document.selection) {
        return document.selection.createRange().text;
    }
    return '';
}

function selectPass(){
    $('#pass').on('click', 'input',function(){
        $(this).select();
    })
}


function makeEqualRules(){
    var showText = 'Pokaż więcej';
    var hideText = 'Zwiń';
    var more = '<span class="more"><span class="moreText">'+showText+'</span></span>';
    $('#rulesDescriptions > li').each(function(){
        var padding = parseInt($(this).find('.rule-desc').css('padding-top')) + parseInt($(this).find('.rule-desc').css('padding-bottom'));
        var h3height = parseInt($(this).find('h3').height());
        if( parseInt($(this).find('.rule-desc > p').height() + padding + h3height ) > ruleDescriptionHeigh){
            //$(this).addClass('dottedBottom').append(more);
            $(this).append(more);
            var tMore = $(this).find('.more');
            var ruleDesc = $(this).find('.rule-desc');
            ruleDesc.addClass('dottedBottom');
            var self = this;
            tMore.click(function(){
                if ( $(self).hasClass('open') ){
                    $(self).removeClass('open');
                    $(this).children('.moreText').text(showText);
                    $(ruleDesc).removeClass('open');
                    var newHeight = ruleDescriptionHeigh;
                    $(ruleDesc).animate({ height:  newHeight }, 400,'swing', function(){/*tMore.css('top',  newHeight - tMore.height())*/});
                    tMore.animate({top: newHeight - tMore.height()}, 400,'swing' );
                }else{
                    var old = $('#rulesDescriptions li.open');
                    $(old).find('.more').click();
                    $(self).addClass('open');
                    $(this).children('.moreText').text(hideText);
                    $(ruleDesc).addClass('open');
                    var newHeight = $(ruleDesc).children('p').innerHeight() + $(ruleDesc).children('h3').innerHeight() + padding ;
                    $(ruleDesc).animate({ height:  newHeight }, 400,'swing', function(){/*tMore.css('top',  newHeight - tMore.height())*/});
                    tMore.animate({top: newHeight - tMore.height()}, 400,'swing' );
                }
            });
        }
    })
}


$(document).ready(function(){
    
    makeEqualRules();
    selectPass();
    $('#send').on('click',function(event) {
        //alert('działa');
        event.stopPropagation();
        var mode = [];
        if( $('#numbers').is(':checked') ){ mode.numbers = true; } else { mode.numbers = false; };
        if( $('#normalChars').is(':checked') ){ mode.normalChars = true; } else { mode.normalChars = false; };
        if( $('#specialChars').is(':checked') ){ mode.specialChars = true; } else { mode.specialChars = false; };
        if( $('#lowerLetters').is(':checked') ){ mode.lowerLetters = true; } else { mode.lowerLetters = false; };
        if( $('#upperLetters').is(':checked') ){ mode.upperLetters = true; } else { mode.upperLetters = false; };
        if( ! ( mode.numbers || mode.normalChars || mode.specialChars || mode.lowerLetters || mode.upperLetters ) ){
            mode.numbers = mode.normalChars = mode.specialChars = mode.lowerLetters = mode.upperLetters = true;
            $('#numbers').attr('checked','checked'); $('#normalChars').attr('checked','checked'); $('#specialChars').attr('checked','checked'); $('#lowerLetters').attr('checked','checked'); $('#upperLetters').attr('checked','checked');
        }
        if( parseInt($('#length').attr('value')) >= minLength ){
            length = parseInt($('#length').attr('value'));
        }else{
            alert('Hasło nie może być mniejsze niż ' + minLength + ' znaków');
            length = minLength;
            $('#length').attr('value',length);
        }
        makePass(mode, length);
        // vardump(mode);
        /*
        $('#form').append('<input type="hidden" value="1" name="ajax" />');
        $.ajax({
                url: 'index.php',
                type: 'POST',
                data: {
                  ajax: 1,
                  numbers: c('numbers'),
                  normalChars: c('normalChars'),
                  specialChars: c('specialChars'),
                  lowerLetters: c('lowerLetters'),
                  upperLetters: c('upperLetters'),
                  length: $('#length').attr('value')
                },
                dataType: 'json'
        }).success( function (result){
            r = result;
            $('#pass pre').text( result.pass );
            console.log( r.power );
        });
        */
        
        return false;
    });
});

