<?
include("config.php");
include("idb_mysql.php");
include("idb_auth.php");

@include($CONF['PEAR_PATH']."Mail.php");
@include($CONF['PEAR_PATH']."Mail/mime.php");

class cms {
  var $IDB;
  var $auth;
  var $isError;
  var $_PAGE;
  var $_error_no;
  var $_error_desc;

  function sessionInit() {
         session_start();
  }
  
  function sessionSet($variable,$value)       {
         $_SESSION['_cms'][$variable]=$value;
  }

  function session($variable)       {
         return $_SESSION['_cms'][$variable];
  }
       
  // inicjalizacja cms-u
  function cms() {
    GLOBAL $CONF;
    $this->isError=0;
    $this->_error_no=0;
    $this->_error_desc=0;
    $this->IDB=new idatabase_mysql($CONF['db_host'],$CONF['db_user'],$CONF['db_pass'],$CONF['db_db']);
    if ($this->IDB->isError) {
      $this->isError=1;
      Header("Location: ".$CONF['DATABASE_ERROR_PAGE']);
    } else {
      $this->auth=new idb_auth($this->IDB);
    }
        $this->sessionInit();
  }

  function setError($num,$str) {
    $this->_error_no=$num;
    $this->_error_desc=$str;
  }
  
  function getError() {
    $ret=array("no"=>$this->_error_no,"desc"=>$this->_error_desc);
    $this->_error_no=0;
    $this->_error_desc=0;
    return $ret;
  }
  
  function get($symbol,$group="",$ind=0,$nav_id=-1) {
    $rs=$this->IDB->query("Select * from params where symbol='".$symbol."' and group_name='".$group."' and ind=".$ind." and nav_id=".$nav_id);
    if ($rs->rowcount()>0) {
      $row=$rs->getValues();
      return $row['value'];
    }
    $this->setError(1,"Nie odnaleziono parametru");
    return "";
  }

  function set($symbol,$val,$def,$group="",$ind=0,$nav_id=-1) {
    $ret=$this->get($symbol,$group,$ind,$nav_id);
    $err=$this->getError();
    if ($err['no']!=0) {
      if ($val=="") $val=$def;
      $this->IDB->query("Insert into params (symbol,group_name,nav_id,ind,value) values ('".$symbol."','".$group."',".$nav_id.",".$ind.",'".$val."')");
    } else {
      $this->IDB->query("Update params set value='".$val."' where symbol='".$symbol."' and group_name='".$group."' and nav_id=".$nav_id." and ind=".$ind);
    }
  }

  function setInModule($symbol,$value,&$CMS) {
    $this->set($symbol,$value,"",$CMS['module']['file'],$CMS['module']['mid']);
  }

  function getFromModule($symbol,&$CMS) {
    return $this->get($symbol,$CMS['module']['file'],$CMS['module']['mid']);
  }

  function setInPage($symbol,$value,&$CMS) {
    $this->set($symbol,$value,"",$CMS['module']['file'],$CMS['module']['mid'],$CMS['navigation']['nid']);
  }

  function getFromPage($symbol,&$CMS) {
    return $this->get($symbol,$CMS['module']['file'],$CMS['module']['mid'],$CMS['navigation']['nid']);
  }


  function paramList($field,$search) {
    $rs=$this->IDB->query("Select * from params where $field = '".$search."'");
    if ($rs->rowcount()>0) {
      while ($row=$rs->getValues()) {
        $rows[]=$row;
      }
      return $rows;
    }
    $this->setError(2,"Nie odnaleziono zestawu parametrw");
    return 0;
  }

  function getIndexedValues($symbol,$group,$nav_id=-1) {
    $rs=$this->IDB->query("Select * from params where symbol='".$symbol."' and group_name='".$group."' and nav_id=".$nav_id);
    if ($rs->rowcount()>0) {
      while ($row=$rs->getValues()) {
        $rows[$row['ind']]=$row;
      }
      return $rows;
    }
    $this->setError(2,"Nie odnaleziono zestawu parametrw");
    return 0;
  }
  
  function install_databases() {
    $this->auth->install("");
    $this->IDB->query("Create table if not exists navigation (nid int primary key auto_increment, title char(150), parent int default 0, active int default 1, module_set int, ord int, redirect char(120), level int default 1, param text, alias char(120))");
    $this->IDB->query("Create table if not exists module_sets (msid int primary key auto_increment, set_name char(40))");
    $this->IDB->query("Create table if not exists modules (mid int primary key auto_increment, set_id int, file char(80), ord int default 1, place char(20), main int default 0, module_name char(40), can_edit int default 1)");
    $this->IDB->query("Create table if not exists tools (tid int primary key auto_increment, tool_name char(70), tool_file char(70))");
    $this->IDB->query("Create table if not exists params (pid int primary key auto_increment, symbol char(30),value text, nav_id int, group_name char(20), ind int)");
  }

  function loadPage($page,$self) {
  	 GLOBAL $CONF;
	 	
    $this->_PAGE=$page;
    $this->_SELF=$self;
	 $p1=$page*1;
	 if ($p1!=0) {
    	$rs=$this->IDB->query("Select * from navigation where nid=".$this->_PAGE);
	 } else {
    	$rs=$this->IDB->query("Select * from navigation where alias='".$this->_PAGE."'");
	 }
	 
	 if ($rs->rowcount()==0) {
	 	if ($_CONF['BAD_REQUEST_PAGE_ID']>0) {
	    	$rs=$this->IDB->query("Select * from navigation where nid=".$_CONF['BAD_REQUEST_PAGE_ID']);
		} else {
		 	die;
		}
	 }

    $this->navigation=$rs->getValues();
    $up=unserialize($this->navigation['param']);
    $this->navigation['param']=$up;
    $rs->free();
    if ($this->navigation['redirect']!="") {
      if (substr($this->navigation['redirect'],0,7)!="http://") {
        $this->_PAGE=$this->navigation['redirect'];
      } else {
        Header("Location: ".$this->navigation['redirect']);
      }
    }
    
    if ($this->navigation['parent']!=0) {
      $parid=$this->navigation['parent'];
      while ($parid!=0) {
        $rs=$this->IDB->query("Select * from navigation where nid=".$parid);
        if ($rs->rowcount()>0) {
          $prow=$rs->getValues();
          $parid=$prow['parent'];
          $this->navigation['tree'][]=$prow;
          $rs->free();
        }
      }
    }
	 
    return $this->navigation;
  }

  function pageInPath($pid) {
    for($i=0;$i<count($this->navigation['tree']);$i++) {
      if ($this->navigation['tree'][$i]['nid']==$pid) return 1;
    }
    if ($this->navigation['nid']==$pid) return 1;
    return 0;
  }
  
       
       
  function moduleCount($place) {
    $rs=$this->IDB->query("Select count(*) as maxc from modules where place='".$place."' and set_id=".$this->navigation['module_set']);
    $row=$rs->getValues();
    $rs->free();
    return $row['maxc'];
  }
  
  function loadModule($place,$num=0) {
    GLOBAL $_CMS;
    
    $rs=$this->IDB->query("Select * from modules where place='".$place."' and set_id=".$this->navigation['module_set']." order by ord limit ".$num.", 1");
    $row=$rs->getValues();
    $rs->free();

    $_CMS['db']=&$this->IDB;
    $_CMS['mode']="show";
    $_CMS['self']=$this->_SELF;
    $_CMS['navigation']=$this->navigation;
    $_CMS['module']=$row;
    $_CMS['cms']=&$this;
    unset($_CMS['result']);
    
    $ret['module']=$row;
    include("cms/mods/".$row['file']);
    
    $ret['result']=$_CMS['result'];
    return $ret;
  }

  function execCommand($file,$command) {
    GLOBAL $_CMS;
    
    $_CMS['db']=&$this->IDB;
    $_CMS['mode']=$command;
    $_CMS['self']="";
    $_CMS['navigation']=$this->navigation;
    $_CMS['module']=0;
    $_CMS['cms']=&$this;
    unset($_CMS['result']);
    
    $ret['module']=$row;
    include("cms/mods/".$file);
    
    $ret['result']=$_CMS['result'];
    return $ret;
  }

  function safechars($str) {
    $nstr=str_replace('\"','&quot;',$str);
    $nstr=str_replace("\\'",'&#039;',$nstr);
    $nstr=str_replace('"','&quot;',$nstr);
    $nstr=str_replace("'","&#039;",$nstr);
    return $nstr;
  }

  function validate($str,$method,$exceptions="",$filled=1) {
    switch($method) {
      case "email":
        $ret=ereg("^[a-zA-Z0-9._-]+@[a-zA-Z0-9.-]+\.[a-zA-Z0-9.-]+$",$str);
      break;
      case "all":
	 $ret=1;
      break;
      case "letters":
	 $ret=1;
      break;
      case "pl":
        $ret=ereg("^[".$exceptions."桡ʦƬa-zA-Z0-9.-]+$",$str);
      break;
      case "ereg":
        $ret=ereg($exceptions,$str);
      break;
      case "number":
        $ret=ereg("^[".$exceptions."0-9]+$",$str);
      break;
      case "currency":
        $ret=ereg("^[0-9]+$",$str);
        if (!$ret) $ret=ereg("^[0-9]+\.[0-9]+$",$str);
      break;
    }
    if ($filled>=1) {
      if (strlen(trim($str))<$filled) $ret=0;
    } else if (trim($str)=="") $ret=1;
    
    return $ret;
  }

  /*
	
  $mimecfg['attachement']=array("file"=>"path_to_file","type"=>"mime/type");
  $mimecfg['text']="plain/text e-mail"; // $body will be used if not set
  $mimecfg['html']="html/text e-mail"; // $body will be used if not set
  */		
  function mail($email,$subject,$body,$headers=0,$mimecfg=0) {
    GLOBAL $CONF;
	 
	 if ($headers!=0) $header=$headers;
	 if (!isset($header['From'])) {
	 	$header['From']=$CONF['mail']['default_from'];
	 }

	 if ($CONF['mail']['mailsystem']=="" || $CONF['mail']['mailsystem']=="pear") {
	    $header['Subject']=$subject;

		 if ($mimecfg!=0) {
		 	$mime=new Mail_mime("\n");
			if ($mimecfg['text']!="") $mime->setTXTBody($mimecfg['text']);
			else $mime->setTXTBody($body);
			if ($mimecfg['html']!="") $mime->setHTMLBody($mimecfg['html']);
			else $mime->setHTMLBody($body);
			$mime->addAttachment($mimecfg['attachement']['file'], $mimecfg['attachement']['type']);

			$body = $mime->get();
			$header = $mime->headers($header);
		 }

	    $m=&Mail::Factory("smtp",array("host"=>$CONF['mail']['host'],"username"=>$CONF['mail']['user'],"password"=>$CONF['mail']['pwd'],"auth"=>true));
	    if (PEAR::isError($m)) echo "F:".$m->getMessage();

	    $ret=@$m->send($email,$header,$body);
	    if (PEAR::isError($ret)) {
	              echo "Email: $email | From: ".$header['From']."<br>";
	              echo "S:".$ret->getMessage();
	    }
	 } else if ($CONF['mail']['mailsystem']=="built_in_php") { 
	 	reset($header);
		$hs="";
		while(list($k,$v)=each($header)) {
			$hs.=$k.":".$v."\n";
		}
		
	 	mail($email,$subject,$body,$hs);
	 }
  }

  function setAccess($lvl,$ident)       {
         $this->sessionSet("access.level",$lvl);
         $this->sessionSet("access.ident",$ident);
  }

  function accessLevel() {
         return $this->session("access.level");
  }

  function accessIdent() {
         return $this->session("access.ident");
  }
       
  function done() {
  }
}
?>
