#!/bin/bash
# $Id: buildpack.sh,v 1.2 2007/08/29 06:08:01 alec Exp $

WORKDIR=`pwd`
NOTDISTRIB="devel"

echo -ne "Temp dir? [$TMPDIR]: "
read TEMPDIR
if [ -z "$TEMPDIR" ]; then
	if [ -z "$TMPDIR" ]; then
		echo "You have to have temp directory..."
		exit
	else
		TEMPDIR=$TMPDIR
	fi
fi

echo -ne "Userpanel version?: "
read LMSVER
if [ -z "$LMSVER" ]; then
	echo "No way ;) We've to get it."
	exit
fi

echo -ne "CVS tag?: "
read CVSTAG
if [ -z "$CVSTAG" ]; then
	echo "No way ;) We've to get it."
	exit
fi

X=$RANDOM
mkdir -p $TEMPDIR/$X
wget --proxy=off "http://cvs.lms.org.pl/viewcvs.cgi/userpanel/userpanel.tar.gz?tarball=1&only_with_tag=${CVSTAG}" -O $TEMPDIR/$X/userpanel.tar.gz
umask 022
cd $TEMPDIR/$X/
tar -xzf userpanel.tar.gz
chmod 777 userpanel/{templates_c,backups}
cd userpanel
rm -Rf $NOTDISTRIB
grep -air '1\.3-cvs' .|cut -d: -f1|sort|uniq|xargs perl -pi -e "s/1\.3-cvs/$LMSVER/g"
chmod 777 templates_c backups
cd ..
tar -czf $WORKDIR/userpanel-$LMSVER.tar.gz userpanel
cd $WORKDIR
