#!/bin/bash

#
#  Script makes list of strings for translation and create strings.php file
#

rm strings.php 2> /dev/null
echo -e "<?php\n" >> strings.php
cat ../doc/COPYRIGHTS >> strings.php
echo "" >> strings.php

echo "Parsing main files"
echo "// Strings for main files" >> strings.php
for FILENAME in `ls ../templates/*.html`
do
    echo -n "$FILENAME... "
    perl -lne 'print for /text="(.*?[^\\])"/g' $FILENAME >> html_strings
    perl -lne 'print for /alt="(.*?[^\\])"/g' $FILENAME >> html_strings
    perl -lne 'print for /title="(.*?[^\\])"/g' $FILENAME >> html_strings
    perl -lne 'print for /\{t[^}]*\}([^{]*)\{\/t}/g' $FILENAME >> html_strings
    echo "done."
done
perl -pi -e 's/\\\$/\$/g' html_strings   	# \$ -> $
perl -pi -e 's/\\/\\\\/g' html_strings   	# \ -> \\
perl -pi -e 's/\x27/\\\x27/g' html_strings	# ' -> \'

for FILENAME in `ls ../lib/*.php`
do
    echo -n "$FILENAME... "
    perl -lne 'print for /trans\(\x27(.*?[^\\])\x27/g' $FILENAME >> php_strings
    echo "done."
done
    echo -n "../index.php... "
    perl -lne 'print for /trans\(\x27(.*?[^\\])\x27/g' ../index.php >> php_strings
    echo "done."

echo -n "Sorting and removing duplicated lines... "
cat html_strings >> tmp_strings
cat php_strings >> tmp_strings
sort tmp_strings 2>/dev/null | uniq > strings.txt
LINESNUM=`cat strings.txt | wc -l`
echo "done. Lines: $LINESNUM"

# delete temp files
rm html_strings 2>/dev/null
rm php_strings 2>/dev/null
rm tmp_strings 2> /dev/null

echo -n "Creating strings.php file... "
if [ "$1" == "diff" ]
then
    cat strings.txt | while read line; do
	OUT=`cat ../lib/locale/$2/strings.php | grep "$line"`;
	if [ "$OUT" == "" ]; then
	    echo $line >> tmp_strings;
	fi 
    done
    LINESNUM=`cat tmp_strings | wc -l`
    echo "done. Lines after diff: $LINESNUM"
else
    cp strings.txt tmp_strings
fi
perl -lne 'print "\$_LANG[\x27$_\x27] = \x27$_\x27;"' tmp_strings >> strings.php 
rm tmp_strings
echo "done."

echo "Now parsing modules"
echo "// Strings for modules" >> strings.php

for MODULENAME in `ls ../modules/`
do
    echo "// Module: $MODULENAME" >> strings.php
    for FILENAME in `ls ../modules/$MODULENAME/templates/*.html`
    do
	echo -n "$FILENAME... "
        perl -lne 'print for /text="(.*?[^\\])"/g' $FILENAME >> html_strings
	perl -lne 'print for /alt="(.*?[^\\])"/g' $FILENAME >> html_strings
	perl -lne 'print for /title="(.*?[^\\])"/g' $FILENAME >> html_strings
        perl -lne 'print for /\{t[^}]*\}([^{]*)\{\/t}/g' $FILENAME >> html_strings
	echo "done."
    done
    perl -pi -e 's/\\\$/\$/g' html_strings   	# \$ -> $
    perl -pi -e 's/\\/\\\\/g' html_strings   	# \ -> \\
    perl -pi -e 's/\x27/\\\x27/g' html_strings	# ' -> \'

    for FILENAME in `ls ../modules/$MODULENAME/*.php`
    do
	echo -n "$FILENAME... "
	perl -lne 'print for /trans\(\x27(.*?[^\\])\x27/g' $FILENAME >> php_strings
	echo "done."
    done

    echo -n "Sorting and removing duplicated lines... "
    cat html_strings >> tmp_strings
    cat php_strings >> tmp_strings
    sort tmp_strings 2>/dev/null | uniq > strings.txt
    LINESNUM=`cat strings.txt | wc -l`
    echo "done. Lines: $LINESNUM"

    # delete temp files
    rm html_strings 2>/dev/null
    rm php_strings 2>/dev/null
    rm tmp_strings 2> /dev/null

    echo -n "Creating strings.php file... "
    if [ "$1" == "diff" ]
    then
	cat strings.txt | while read line; do
	    OUT=`cat ../modules/$MODULENAME/locale/$2/strings.php | grep "$line"`;
	    if [ "$OUT" == "" ]; then
		echo $line >> tmp_strings;
	    fi 
	done
	LINESNUM=`cat tmp_strings | wc -l`
	echo "done. Lines after diff: $LINESNUM"
    else
	cp strings.txt tmp_strings
    fi
    perl -lne 'print "\$_LANG[\x27$_\x27] = \x27$_\x27;"' tmp_strings >> strings.php 
    rm tmp_strings
    echo "done."
done
echo -e "\n?>" >> strings.php
echo "All done."			