<?php

/*
 *  LMS Userpanel version 1.3-cvs
 *
 *  (C) Copyright 2004-2007 Userpanel Developers
 *
 *  Please, see the doc/AUTHORS for more information about authors!
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License Version 2 as
 *  published by the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
 *  USA.
 *
 *  $Id: ULMS.class.php,v 1.19 2007/12/12 11:54:39 alec Exp $
 *
*/		     

// Here we are creating wrappers for older LMS versions

$lmsdbversion = $DB->GetOne("SELECT keyvalue FROM dbinfo WHERE keytype = 'dbversion'");

if($lmsdbversion >= 2007071600)
{
    // Extending LMS class for Userpanel-specific functions
    class ULMS extends LMS
    {
	function docnumber($id)
	{
		if($doc = $this->DB->GetRow('SELECT number, cdate, template 
					FROM documents 
					LEFT JOIN numberplans ON (numberplanid = numberplans.id)
					WHERE documents.id = ?', array($id)))
			return docnumber($doc['number'], $doc['template'], $doc['cdate']);
		else
			return NULL;
	}
	
	function GetCustomer($id)
	{
		if($result = $this->DB->GetRow('SELECT c.*, '.$this->DB->Concat('UPPER(c.lastname)',"' '",'c.name').' AS customername
	                                FROM customers c WHERE c.id = ?', array($id)))
		{
                        $result['balance'] = $this->GetCustomerBalance($result['id']); 
			$result['bankaccount'] = bankaccount($result['id']); 
			$result['messengers'] = $this->DB->GetAllByKey('SELECT uid, type FROM imessengers WHERE customerid = ? ORDER BY type', 'type', array($id));
		        $result['contacts'] = $this->DB->GetAllByKey('SELECT id, phone, name FROM customercontacts WHERE customerid = ? ORDER BY id', 'id', array($id));
			
			return $result;
		}
		else
			return NULL;
	}

	function GetCustomerMessage($id)
	{
		return $this->DB->GetOne('SELECT message FROM customers WHERE id=?', array($id));
	}
	
	function GetCustomerTickets($id)
	{
		return $this->DB->GetAll('SELECT * FROM rttickets WHERE customerid=? ORDER BY createtime DESC', array($id));
	}

	function GetTicketContents($id)
	{
		global $RT_STATES;
		
		$ticket = $this->DB->GetRow('SELECT rttickets.id AS ticketid, queueid, rtqueues.name AS queuename, 
				    requestor, state, owner, customerid, cause, '
				    .$this->DB->Concat('UPPER(customers.lastname)',"' '",'customers.name').' AS customername, 
				    users.name AS ownername, createtime, resolvetime, subject
				FROM rttickets
				LEFT JOIN rtqueues ON (queueid = rtqueues.id)
				LEFT JOIN users ON (owner = users.id)
				LEFT JOIN customers ON (customers.id = customerid)
				WHERE rttickets.id = ?', array($id));
		
		$ticket['messages'] = $this->DB->GetAll('SELECT rtmessages.id AS id, mailfrom, subject, body, createtime, '
				    .$this->DB->Concat('UPPER(customers.lastname)',"' '",'customers.name').' AS customername, 
				    userid, users.name AS username, customerid
				FROM rtmessages
				LEFT JOIN customers ON (customers.id = customerid)
				LEFT JOIN users ON (users.id = userid)
				WHERE ticketid = ? ORDER BY createtime ASC', array($id));
		
		list($ticket['requestoremail']) = sscanf($ticket['requestor'], "<%[^>]");

		return $ticket;
	}
    }		
}
else
	die('Not supported LMS version. Userpanel needs LMS-1.10 or higher!');

?>
