<?php

/*
 *  LMS Userpanel version 1.3-cvs
 *
 *  (C) Copyright 2004-2007 Userpanel Developers
 *
 *  Please, see the doc/AUTHORS for more information about authors!
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License Version 2 as
 *  published by the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
 *  USA.
 *
 *  $Id: upgradedb.php,v 1.11 2007/07/12 09:23:08 alec Exp $
 */
 
define('UP_DBVERSION', '2005120900'); // here should be always the newest version of database!
				 // it placed here to avoid read disk every time when we call this file.

/*
 * This file contains procedures for upgradeing automagicly database.
 */

if (!function_exists('getdir')) {
function getdir($pwd = './', $pattern = '^.*$')
{
        if ($handle = @opendir($pwd))
        {
                while (($file = readdir($handle)) !== FALSE)
                        if(ereg($pattern,$file))
                                $files[] = $file;
                closedir($handle);
        }
        return $files;
}
}

$dbversions = $DB->GetAllByKey('SELECT keyvalue, keytype FROM dbinfo', 'keytype');

/*
 * Upgrade of userpanel database
 */

$dbversion = isset($dbversions['up_dbversion']) ? $dbversions['up_dbversion']['keyvalue'] : 0;
if(UP_DBVERSION > $dbversion)
{
	$lastupgrade = $dbversion;

	$upgradelist = getdir(USERPANEL_LIB_DIR.'/upgradedb/', '^'.$_DBTYPE.'.[0-9]{10}.php$');

	if(sizeof($upgradelist))
		foreach($upgradelist as $upgrade)
		{
			$upgradeversion = ereg_replace('^'.$_DBTYPE.'.([0-9]{10}).php$','\1',$upgrade);

			if($upgradeversion > $dbversion && $upgradeversion <= UP_DBVERSION)
				$pendingupgrades[] = $upgradeversion;
		}
		
	if(sizeof($pendingupgrades))
	{
		sort($pendingupgrades);
		foreach($pendingupgrades as $upgrade)
		{	
			include(USERPANEL_LIB_DIR.'/upgradedb/'.$_DBTYPE.'.'.$upgrade.'.php');
			if(!sizeof($DB->errors))
				$lastupgrade = $upgrade;
			else
				break;
		}
	}
}

/*
 * Upgrade of database related to userpanel modules
 */
foreach ($USERPANEL->MODULES as $menupos) if($menupos['dbver']>0)
{
	$dbversion = isset($dbversions['up_module_'.$menupos['module']]) ? $dbversions['up_module_'.$menupos['module']]['keyvalue'] : 0;
	
	if ($dbversion<$menupos['dbver'])
	{
		$pendingupgrades = NULL;
		$lastupgrade = $dbversion;
		
		$upgradelist = getdir(USERPANEL_DIR.'/modules/'.$menupos['module'].'/upgradedb/', '^'.$_DBTYPE.'.[0-9]{10}.php$');

		if(sizeof($upgradelist))
			foreach($upgradelist as $upgrade)
			{
				$upgradeversion = ereg_replace('^'.$_DBTYPE.'.([0-9]{10}).php$','\1',$upgrade);
				
				if($upgradeversion > $dbversion)
					$pendingupgrades[] = $upgradeversion;
			}

		if(sizeof($pendingupgrades))
		{
			sort($pendingupgrades);
			foreach($pendingupgrades as $upgrade)
			{	
				include(USERPANEL_DIR.'/modules/'.$menupos['module'].'/upgradedb/'.$_DBTYPE.'.'.$upgrade.'.php');
				if(!sizeof($DB->errors))
					$lastupgrade = $upgrade;
				else
					break;
			}
		}
	}
}

?>
