<?php
$czas_przejscia = 25; // podaj czas przejścia w sekundach;
header('Refresh: '.$czas_przejscia.'; URL=https://boa.i24.pl');?>
<!DOCTYPE html>
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="pl" lang="pl">
<head>
  <meta content="text/html; charset=utf-8" http-equiv="content-type" />
  <title>Zmiana adresu strony do eBOA (elektronicznego Biura Obsługi Abonenta)</title>
  <link type="text/css" rel="stylesheet" href="https://boa.i24.pl/style/custom/zero.css" />

	<style>
		html{height: 100%;}
		body{position: relative;  padding-top: 30px; color: #1a1a18; font-size: 12px; height: 100%;}
		.center{width: 710px; margin: 0 auto; position: relative; min-height: 100%;}
		.login{background: none; background-color: #fff !important; width: 710px; position: relative; left: 50%; margin-left: -430px; top: auto; margin-top: 75px; }
		#logo{text-align: center; margin-bottom: 20px;}
		#slogan{text-align: center; font-size: 18px; }

		#content{padding-bottom: 120px; position: relative; }

		.leftSide{background: url('https://boa.i24.pl/style/custom/images/spacer.png') 100% 50% transparent no-repeat; width: 430px; float: left; padding-right: 50px; padding: 60px 0;}
		h3{font: bold 14px arial, serif; line-height: 30px;}
		.red{color: #940000;}
		.rightSide{width: 190px; float: left; padding-left: 35px; height: 240px;}

		#login{text-align: right;}
		label{font-weight: bold; width: 80px; display: inline-block; line-height: 30px; height: 30px;}
		input{background-color: #d4d4d4; border-radius: 5px; line-height: 30px; padding: 0 5px; height: 30px; width: 150px; margin-left: 10px; font-size: 16px;}
		#loginFormSubmit{background-color: #940000; color: #fff; font-weight: bold; float: right; font-size: 14px;}
		#loginFormSubmit:hover{cursor: pointer; cursor: hand; color: #c0c0c0; background-color: #af0000; }
		#webvisor, #inet{ display: block; height: 30px; width: 155px; background: url('https://boa.i24.pl/style/custom/images/webvisor.png') 50% 50% transparent no-repeat; float: left; text-indent: -999999px;}
		#inet{ background-image: url('https://boa.i24.pl/style/custom/images/inet-poludnie.png'); float: right; }
		#bottom{ width: 400px; left: 50%; margin-left: -200px; position: absolute; bottom: 0; padding-bottom: 20px;}
		#redirect{border-radius: 5px; line-height: 30px; padding: 0 5px; height: 60px; width: 200px; margin-left: 10px; background-color: #940000; color: #fff; font-weight: bold; float: right; font-size: 14px; text-align: center; line-height: 60px; display: inline-block; }
		#redirect:hover{color: #c0c0c0; background-color: #af0000; }
		.table{display: table;}
		.table-cell{display: table-cell; vertical-align: middle;}
		.clear{clear: both;}
	</style>

</head>
<body>
	<div class="center">
		<div id="content">
			<h1 id="logo"><img alt="i24 - internet" src="https://boa.i24.pl/style/custom/images/logo.png"></h1>
			<h2 id="slogan">elektroniczne Biuro Obsługi Abonenta (eBOA)</h2>
			<div class="login">
				<div class="leftSide">
					<h3 class="red">UWAGA</h3>
					<p>
						<strong>Zmiana adresu strony dla abonentów.</strong><br>
						Nowy adres strony do obsługi abonentów to <a class="red" href="https://boa.i24.pl/">boa.i24.pl</a>
					</p>
					<p>Za kilka sekund nastąpi automatyczne przejście na nową stronę</p>
				</div>
				<div class="rightSide table">
					<p class="table-cell">
						<a href="https://boa.i24.pl/" id="redirect">Przejdź na nową stronę <?php echo $czas_przejscia;?></a>
					</p>
				</div>
				<div class="clear"></div>
			</div><!-- /.login -->
		</div><!-- /#content -->
		<div id="bottom">
			<a id="webvisor" href="http://www.webvisor.pl" title="Profesjonalne rozwiązania IT dla firm">Webvisor</a>
			<a id="inet" href="http://www.inet-poludnie.pl" title="Internet dla domu i firmy">iNET Południe</a>
		</div>
	</div><!-- /.center -->
	<script>
		var button = document.getElementById("redirect");
		var counter=setInterval(timer, 1000); 
		var count = <?php echo $czas_przejscia; ?>;
		function timer()
		{
		  count=count-1;
		  if (count <= 0)
		  {
			 clearInterval(counter);
			 button.click();
			 return;
		  }
			button.innerHTML= "Przejdź na nową stronę "+count;
		}
		
  </script>
</body>
</html>
