<?php

/**
 * Freshmail Subscription main file
 * 
 * @package    Freshmail
 * @subpackage Subscription
 * @link http://freshmail.pl
 * @license        GNU/GPL, see LICENSE.php
 * 
 */
 
defined('_JEXEC') or die('Restricted access');

jimport('joomla.application.application');
jimport('joomla.environment.uri');

$login = $params->get('FMlogin');
$password = $params->get('FMpassword');
$subscriberListHash = $params->get('FMsubscribersListHash');

if (empty($login) || empty($password) || empty($subscriberListHash)) {
    echo 'Uzupełnij podstawowe parametry newslettera';
    exit;
}

define('SAVE_KEY', 'zapisz');
define('FM_SOAP_WSDL', 'https://app.freshmail.pl/soap?wsdl');

$email = '';
$message = '';
$name = '';

$customFields = array(
    $params->get('FMcustomField1') => $params->get('FMcustomFieldName1'),
    $params->get('FMcustomField2') => $params->get('FMcustomFieldName2'),
    $params->get('FMcustomField3') => $params->get('FMcustomFieldName3'),
);

foreach ($customFields as $key => $value) {
    if (empty($key) || empty($value)) {
        unset($customFields[$key]);
    }
}

if (!empty($_POST) && !empty($_POST['freshmail']) && SAVE_KEY == $_POST['freshmail'] && !empty($_POST['FMemail'])) {
	$email = trim($_POST['FMemail']);

    if (!empty($_POST['FMname'])) {
        $name = trim($_POST['FMname']);
    }
    
	try {
		$soapClient = new SoapClient(FM_SOAP_WSDL);
            $soapClient->loginAccount(array(
            'login' => $login,
            'password' => $password
        ));

        //dodawanie subskrybenta
        $subscriber = array();
        $subscriber['subscriberListHash'] = $subscriberListHash;
        $subscriber['email'] = $email;
        $subscriber['name'] = $name;

        $result = $soapClient->createSubscriber($subscriber);
        $message = 'Twój e-mail został dodany do listy subskrybcyjnej. Wiadomość z linkiem aktywacyjnym została wysłana na Twój adres poczty.';

        $customFieldValues = array();
        foreach ($customFields as $key => $value) {
            if (!empty($_POST['FMcustomField'][$key])) {
                $customFieldValues[] = array(
                    'customFieldHash' => $key,
                    'value' => trim($_POST['FMcustomField'][$key])
                );
            }
        }

        if (!empty($customFieldValues)) {
            $chooseSubscriber = array(
                'byColumn' => 'subscriberEmail',
                'columnValue' => $email,
                'subscriberListHash' => $subscriberListHash
            );

            $set = array(
                'email' => $email,
                'name' => $name,
                'state' => 'dontChange',
                'customFieldsValues' => $customFieldValues
            );

            $soapClient->updateSubscriber(array('chooseSubscriber' => $chooseSubscriber, 'set' => $set));
        }
	} catch (SoapFault $e) {
        if ($e->faultcode == 4) {
           $message = 'Twój e-mail jest już zapisany do tego newslettera.';
        } else {
            
           $message  = "Błąd komunikacji z FreshMailem({$e->faultstring}).<br /><br /><a href='/'>Powrót</a>";
        }
        
	}
    $soapClient->logoutAccount();
}

?>
<div id="mailing-close">X</div>
<?php if($message) { ?>
<div class="form-message" id="FMmessageBox"><?php echo $message; ?></div>
<?php } else { ?>
<form class="form-message" name="freshmail" id="freshmail" method="post"  action="">
    <table style="width: 760px;">
        <tr>
            <td style="width: 590px;">
                <input type="hidden" name="subscribers_list_hash" value="p1ixivcpcm" />
                <input type="hidden" name="freshmail" value="<?php echo SAVE_KEY; ?>" />
                <label for="FMemail"> E-mail:</label>
                <input id="FMemail" name="FMemail" value="" class="text" />
                <?php if (1 == $params->get('FMshowName')): ?>
                    <label for="FMname"> Imię: </label>
                    <input id="FMname" name="FMname" value="" class="text" />
                <? endif; ?>
                <?php foreach ($customFields as $key => $value): ?>
                    <label for="FMcustomField[<?php echo $key; ?>]">
                    <?php echo $value; ?>: </label>
                    <input id="FMcustomField[<?php echo $key; ?>]" name="FMcustomField[<?php echo $key; ?>]" value="" class="text" />
                    
                <?php endforeach; ?>
                <br />
            </td>
            <td style="width: 250px;">
                <input type="submit" value="Wyślij" class="button" />
                <p>Zapisując się na nasz <strong>newsletter</strong> akceptujesz postanowienia <a href="regulamin.pdf" title="Regulamin" target="_blank" >regulaminu</a> konkursu.</p>
            </td>
        </tr>
    </table>
	
</form>
<?php } ?>

