<?php

/**
 * Freshmail Subscription main file
 * 
 * @package    Freshmail
 * @subpackage Subscription
 * @link http://freshmail.pl
 * @license        GNU/GPL, see LICENSE.php
 * 
 */
 
defined('_JEXEC') or die('Restricted access');

jimport('joomla.application.application');
jimport('joomla.environment.uri');

$login = $params->get('FMlogin');
$password = $params->get('FMpassword');
$subscriberListHash = $params->get('FMsubscribersListHash');

if (empty($login) || empty($password) || empty($subscriberListHash)) {
    echo 'Uzupełnij podstawowe parametry newslettera';
    exit;
}

define('SAVE_KEY', 'zapisz');
define('FM_SOAP_WSDL', 'https://app.freshmail.pl/soap?wsdl');

$email = '';
$message = '';
$name = '';

$customFields = array(
    $params->get('FMcustomField1') => $params->get('FMcustomFieldName1'),
    $params->get('FMcustomField2') => $params->get('FMcustomFieldName2'),
    $params->get('FMcustomField3') => $params->get('FMcustomFieldName3'),
);

foreach ($customFields as $key => $value) {
    if (empty($key) || empty($value)) {
        unset($customFields[$key]);
    }
}

if (!empty($_POST) && !empty($_POST['freshmail']) && SAVE_KEY == $_POST['freshmail'] && !empty($_POST['FMemail'])) {
	$email = trim($_POST['FMemail']);

    if (!empty($_POST['FMname'])) {
        $name = trim($_POST['FMname']);
    }

	try {
		$soapClient = new SoapClient(FM_SOAP_WSDL);

        $soapClient->loginAccount(array(
            'login' => $login,
            'password' => $password
        ));

        //dodawanie subskrybenta
        $subscriber = array();
        $subscriber['subscriberListHash'] = $subscriberListHash;
        $subscriber['email'] = $email;
        $subscriber['name'] = $name;

        $result = $soapClient->createSubscriber($subscriber);
        $message = 'Twój e-mail został dodany do listy subskrybcyjnej. Wiadomość z linkiem aktywacyjnym została wysłana na Twój adres poczty.';

        $customFieldValues = array();
        foreach ($customFields as $key => $value) {
            if (!empty($_POST['FMcustomField'][$key])) {
                $customFieldValues[] = array(
                    'customFieldHash' => $key,
                    'value' => trim($_POST['FMcustomField'][$key])
                );
            }
        }

        if (!empty($customFieldValues)) {
            $chooseSubscriber = array(
                'byColumn' => 'subscriberEmail',
                'columnValue' => $email,
                'subscriberListHash' => $subscriberListHash
            );

            $set = array(
                'email' => $email,
                'name' => $name,
                'state' => 'dontChange',
                'customFieldsValues' => $customFieldValues
            );

            $soapClient->updateSubscriber(array('chooseSubscriber' => $chooseSubscriber, 'set' => $set));
        }
	} catch (SoapFault $e) {
        if ($e->faultcode == 4) {
           $message = 'Twój e-mail jest już zapisany do tego newslettera.';
        } else {
           $message = "Błąd komunikacji z FreshMailem({$e->faultstring}).";
        }
	}
    $soapClient->logoutAccount();
}

?>
<div style="margin-bottom: 10px" id="FMmessageBox"><?php echo $message; ?></div>
<form name="freshmail" id="freshmail" method="post" >
	<input type="hidden" name="freshmail" value="<?php echo SAVE_KEY; ?>" />
	Adres e-mail:<br />
	<input id="FMemail" name="FMemail" value="" />
    <?php if (1 == $params->get('FMshowName')): ?>
        <br />
        Nazwa: <br />
        <input id="FMname" name="FMname" value="" />
    <? endif; ?>

    <?php foreach ($customFields as $key => $value): ?>
        <br />
        <?php echo $value; ?>: <br />
        <input name="FMcustomField[<?php echo $key; ?>]" value="" />
    <?php endforeach; ?>
	<br />
   	<br />
	<input type="submit" value="Zapisz" />
</form>

